clear all

* Set Folder to input one

cd ..\Inputs

* Import and clean output gap data

import excel "Greenbook Output Gap.xls", ///
sheet(Output Gap) cellrange(A3) firstrow clear

* Rename variables

rename A FOMCmeetingdate
rename B GBpublicationdate
rename C Yearquarter

* Label variables

label var D "Output gap 8 periods into the past"
label var E "Output gap 7 periods into the past"
label var F "Output gap 6 periods into the past"
label var G "Output gap 5 periods into the past"
label var H "Output gap 4 periods into the past"
label var I "Output gap 3 periods into the past"
label var J "Output gap 2 periods into the past"
label var K "Output gap 1 period into the past"
label var L "Output gap in the current period"
label var M "Output gap 1 period into the future"
label var N "Output gap 2 periods into the future"
label var O "Output gap 3 periods into the future"
label var P "Output gap 4 periods into the future"
label var Q "Output gap 5 periods into the future"
label var R "Output gap 6 periods into the future"
label var S "Output gap 7 periods into the future"
label var T "Output gap 8 periods into the future"
label var U "Output gap 9 periods into the future"

* Rename more variables

rename D gapm8
rename E gapm7
rename F gapm6
rename G gapm5
rename H gapm4
rename I gapm3
rename J gapm2
rename K gapm1
rename L gapf0
rename M gapf1
rename N gapf2
rename O gapf3
rename P gapf4
rename Q gapf5
rename R gapf6
rename S gapf7
rename T gapf8
rename U gapf9

* Generate observation indicator

gen t=_n

* Generate date variables

gen year=year(GBpublicationdate)
gen quarter=quarter(GBpublicationdate)
gen month=month(GBpublicationdate)
gen wk=week(GBpublicationdate)
gen day=day(GBpublicationdate)

* Generate meeting variables

gen meeting=substr(FOMCmeetingdate,8,1)
label var meeting "FOMC meeting number"
destring meeting, replace force
drop if GBpublicationdate==.

* Save temporary dataset in input folder

save Greenbook_GAP, replace

* Import and clean real GDP growth data

import excel "Greenbook Other Variables.xls", ///
sheet(gRGDP) cellrange(A1) firstrow clear

* Replace certain meeting dates that are one or two days off between datasets

tostring GBdate, replace force
replace GBdate="19670712" if GBdate=="19670717"
replace GBdate="19710818" if GBdate=="19710820"
replace GBdate="19730613" if GBdate=="19730618"
replace GBdate="19760614" if GBdate=="19760616"
replace GBdate="19770413" if GBdate=="19770415"
replace GBdate="19791012" if GBdate=="19791012"
replace GBdate="19910626" if GBdate=="19910628"
replace GBdate="19920624" if GBdate=="19920626"
replace GBdate="19930127" if GBdate=="19930129"
replace GBdate="19940629" if GBdate=="19940630"

* Generate date variables

gen year=substr(GBdate,1,4)
destring year, replace force
gen month=substr(GBdate,5,2)
destring month, replace force
gen day=substr(GBdate,7,2)
destring day, replace force

tostring DATE, replace force
gen quarter=substr(DATE,6,1)
destring quarter, replace force

* Save another temporary dataset

save Greenbook_gRGDP, replace

* Merge the two previous datasets
	
use Greenbook_GAP, clear

merge 1:1 year quarter month day using Greenbook_gRGDP
drop if _merge==2
drop _merge DATE GBdate

* Turn growth rates, which are Q/Q but annualized into simple Q/Q growth rates

foreach v of varlist gRGDP* {
	gen Q`v' = ((1+`v'/100)^(1/4)-1)*100
}

* Generate growth rates for potential output based on the gap estimates and the
* growth estimates for nominal gdp

forvalues r=1/4 {
gen gRpotm`r'=(((gapm`=`r'+1'/100+1)/(gapm`r'/100+1)*(QgRGDPB`r'/100+1))-1)*400
}

gen gRpot0=(((gapm1/100+1)/(gapf0/100+1)*(QgRGDPF0/100+1))-1)*400

forvalues r=1/6 {
gen gRpot`r'=(((gapf`=`r'-1'/100+1)/(gapf`r'/100+1)*(QgRGDPF`r'/100+1))-1)*400
}

order gRpotm4 gRpotm3 gRpotm2 gRpotm1, before(gRpot0)

* Keep only first meetings in a quarter

drop if GBpub==10988
egen mindate=min(GBpub), by(Yearquarter)
keep if mindate==GBpub
egen tt=group(year quarter)

* Set time series to be able to use lag and difference operators

tsset tt

foreach var in 0 1 2 3 4 5 {
	gen revRpot`var'=gRpot`var'-l.gRpot`=`var'+1'
}

foreach var in 1 2 3 4 5 {
	gen rev2Rpot`=`var'-1'=l.gRpot`var'-l2.gRpot`=`var'+1'
}

egen sumRpot=rowmean(revRpot*)
egen sum1Rpot4=rowmean(revRpot0 revRpot1 revRpot2 revRpot3)

* Create revision for the same time but this revision is made in the previous 
* period this is the term from Coibion and Gorodnichenko

egen sum2Rpot4=rowmean(rev2Rpot0 rev2Rpot1 rev2Rpot2 rev2Rpot3)

* Generate summation of growth rates for potential output

gen gRpot_cum4=(gRpot1+gRpot2+gRpot3+gRpot4)/4
gen gRpot_cum3=(gRpot1+gRpot2+gRpot3)/3

* Keep only relevant variables and rename

keep year quarter gRpot* sumRpot sum1Rpot4 sum2Rpot4 revRpot* rev2Rpot*

ds year quarter, not
foreach var of varlist `r(varlist)' {
	rename `var' GRE`var'
}

* Change to output directory and save

cd ..\Outputs
save Data_GRE, replace
